// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /var/mnt/Data/CVS_REPO/Clients/Marketcircle/Frameworks/MCApplication/MCSplitView.h,v 1.8 2007/02/01 03:19:18 alalani Exp $

#import <AppKit/NSSplitView.h>

@interface MCSplitView : NSSplitView
{
    NSString 	*positionAutosaveName;
	NSColor		*dividerColor;
	NSImage		*dividerImage;

	BOOL doNotDrawDivider;
	BOOL doNotAcceptMouseEvents;
	BOOL doNotDrawDividerImage;
	
	float __dividerThickness;
	
	// If the divider should cause a drag outside its bounds on either side, use this offset to provide how wide/tall it should catch events for
	float expandDividerByOffset;
}
// this is a forwarded mouse down, could be from anywhere, but tells us to use that mouse down to drag the splitter(i.e. an auxiliary view that controls the split view could use this)
- (void)forwardMouseDown:(NSEvent *)theEvent;

- (void)setPositionAutosaveName:(NSString *)name;
- (NSString *)positionAutosaveName;

- (void)setDividerColor:(NSColor *)aColor;
- (NSColor *)dividerColor;

- (void)setDividerImage:(NSImage *)anImage;
- (NSImage *)dividerImage;

- (BOOL)doNotDrawDivider;
- (void)setDoNotDrawDivider:(BOOL)flag;
- (BOOL)doNotAcceptMouseEvents;
- (void)setDoNotAcceptMouseEvents:(BOOL)flag;
- (BOOL)doNotDrawDividerImage;
- (void)setDoNotDrawDividerImage:(BOOL)flag;

- (float)expandDividerByOffset;
- (void)setExpandDividerByOffset:(float)anExpandDividerByOffset;

- (NSArray *)splitProportions;
- (void)setSplitProportions:(NSArray *)array;

- (void)mcSetDividerThickness:(CGFloat)aDividerThickness;

- (NSArray *)splitterRects;
- (NSRect)splitterRectIncludingOffset;

@end


@interface NSObject (MCSplitViewDelegate)

- (void)splitViewDidFinishReszingSubviews: (MCSplitView*)sender;

@end
